﻿using SnapsLibrary;

class Ch07_13_CompleteProgram
{
    public void StartProgram()
    {
        while (true)
        {
            SnapsEngine.SetTitleString("Sprzedaż lodów");

            // Find out how many sales values are being stored
            int noOfStands = SnapsEngine.ReadInteger("Ile stoisk z lodami?");
            int[] sales = new int[noOfStands];

            // Loop round and read the sales values
            for (int count = 0; count < sales.Length; count = count + 1)
            {
                // User likes to count from 1, not zero
                int displayCount = count + 1;
                sales[count] = SnapsEngine.ReadInteger("Wprowadź sprzedaż dla stoiska " + displayCount);
            }

            while (true)
            {
                string command = SnapsEngine.SelectFrom6Buttons(
                    "Od najniższej do najwyższej",
                    "Od najwyższej do najniższej",
                    "Najwyższa i najniższa",
                    "Sprzedaż całkowita",
                    "Sprzedaż średnia",
                    "Wprowadź nowe dane");

                if (command == "Od najniższej do najwyższej")
                {
                    SnapsEngine.SetTitleString("Od najniższej do najwyższej");

                    for (int pass = 0; pass < sales.Length - 1; pass = pass + 1)
                    {
                        // clear the swap flag for this pass
                        bool doneSwap = false;

                        // Make a pass down the array swapping elements
                        for (int i = 0; i < sales.Length - 1; i = i + 1)
                        {
                            if (sales[i] > sales[i + 1])
                            {
                                // the elements are in the wrong order, need to swap them round
                                int temp = sales[i];
                                sales[i] = sales[i + 1];
                                sales[i + 1] = temp;
                                doneSwap = true;
                            }
                        }
                        if (!doneSwap)
                            // quit the sort if we didn't do any swaps
                            break;
                    }

                    // Now print out the sorted data

                    SnapsEngine.ClearTextDisplay();

                    // Add a line to the string for each sales figure
                    for (int count = 0; count < sales.Length; count = count + 1)
                    {
                        SnapsEngine.AddLineToTextDisplay("Sprzedaż: " + sales[count]);
                    }

                    SnapsEngine.WaitForButton("Kontynuuj");
                    SnapsEngine.DisplayString("");
                }


                if (command == "Od najwyższej do najniższej")
                {
                    SnapsEngine.SetTitleString("Od najwyższej do najniższej");

                    for (int pass = 0; pass < sales.Length - 1; pass = pass + 1)
                    {
                        // clear the swap flag for this pass
                        bool doneSwap = false;

                        // Make a pass down the array swapping elements
                        for (int i = 0; i < sales.Length - 1; i = i + 1)
                        {
                            if (sales[i] < sales[i + 1])
                            {
                                // the elements are in the wrong order, need to swap them round
                                int temp = sales[i];
                                sales[i] = sales[i + 1];
                                sales[i + 1] = temp;
                                doneSwap = true;
                            }
                        }
                        if (!doneSwap)
                            // quit the sort if we didn't do any swaps
                            break;
                    }

                    // Now print out the sorted data

                    SnapsEngine.ClearTextDisplay();

                    // Add a line to the string for each sales figure
                    for (int count = 0; count < sales.Length; count = count + 1)
                    {
                        SnapsEngine.AddLineToTextDisplay("Sprzedaż: " + sales[count]);
                    }

                    SnapsEngine.WaitForButton("Kontynuuj");
                    SnapsEngine.DisplayString("");
                }

                if (command == "Od najwyższej do najniższej")
                {
                    SnapsEngine.SetTitleString("Od najwyższej do najniższej");

                    int highest = sales[0];
                    int lowest = sales[0];
                    foreach (int sale in sales)
                    {
                        if (sale > highest)
                            highest = sale;
                        if (sale < lowest)
                            lowest = sale;
                    }

                    SnapsEngine.DisplayString("Najwyższa " + highest + "\n" +
                        "Najniższa " + lowest);

                    SnapsEngine.WaitForButton("Kontynuuj");
                    SnapsEngine.DisplayString("");
                }

                if (command == "Sprzedaż całkowita")
                {
                    SnapsEngine.SetTitleString("Sprzedaż całkowita");

                    int totalSales = 0;
                    foreach (int sale in sales)
                        totalSales = totalSales + sale;

                    SnapsEngine.DisplayString("Sprzedaż całkowita " + totalSales);

                    SnapsEngine.WaitForButton("Kontynuuj");
                    SnapsEngine.DisplayString("");
                }

                if (command == "Sprzedaż średnia")
                {
                    SnapsEngine.SetTitleString("Sprzedaż średnia");

                    int total = 0;
                    foreach (int sale in sales)
                        total = total + sale;

                    float average = (float)total / sales.Length;

                    SnapsEngine.DisplayString("Sprzedaż średnia " + average);

                    SnapsEngine.WaitForButton("Kontynuuj");
                    SnapsEngine.DisplayString("");
                }

                if (command == "Wpisz liczby")
                {
                    SnapsEngine.SetTitleString("Wprowadź nowe dane");

                    string confirm = SnapsEngine.SelectFrom2Buttons("Wprowadź nowe dane", "Cancel");

                    if (confirm == "Wprowadź nowe dane")
                    {
                        break;
                    }
                }
            }
        }
    }
}
